(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2524,         77]*)
(*NotebookOutlinePosition[      3197,        101]*)
(*  CellTagsIndexPosition[      3153,         97]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(M = \(f \((H)\)\ \ \ \ \ \[OAcute]\ \ \ \ \ B = f \((H)\)\)\)], "Input"],

Cell[BoxData[
    \(B = \(\[Mu]\_0\) \((H + M)\)\)], "Input"],

Cell[BoxData[
    \(M = \(\[Chi]\ H\ \ \ \[LongRightArrow]\ \ \ B = \(\(\[Mu]\_0\) \((1 + \
\[Chi])\) H = \[Mu]\ H\)\)\)], "Input"],

Cell[BoxData[
    \(w = \[Mu]\_0\ A\ f\)], "Input"],

Cell[BoxData[
    \(H = \(n\ V\_x\)\/R\)], "Input"],

Cell[BoxData[
    \(M\  = \ \(R'\ C\ V\_y\)\/\(\[Mu]\_0\ N' S\)\)], "Input"],

Cell[BoxData[
    \(\[Chi] = \(\[CapitalDelta]M\/\[CapitalDelta]H = \(\(\(R'\ C\ \
\[CapitalDelta]Y\)\/\(\[Mu]\_0\ N' S\)\)\/\(\(n\ \[CapitalDelta]X\)\/R\) = \
\(R\ R'\ C\ \[CapitalDelta]Y\)\/\(n\ \[Mu]\_0\ N' S\ \
\[CapitalDelta]X\)\)\)\)], "Input"],

Cell[BoxData[
    \(\[Mu] = \(\[Mu]\_0\) \((1 + \[Chi])\)\)], "Input"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 547}},
WindowSize->{495, 389},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 92, 1, 35, "Input"],
Cell[1812, 52, 61, 1, 35, "Input"],
Cell[1876, 55, 131, 2, 35, "Input"],
Cell[2010, 59, 51, 1, 35, "Input"],
Cell[2064, 62, 51, 1, 48, "Input"],
Cell[2118, 65, 76, 1, 52, "Input"],
Cell[2197, 68, 250, 4, 72, "Input"],
Cell[2450, 74, 70, 1, 35, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

