(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2547,         79]*)
(*NotebookOutlinePosition[      3220,        103]*)
(*  CellTagsIndexPosition[      3176,         99]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(C = \(\[Epsilon]\_0\) S\/d\)], "Input"],

Cell[BoxData[
    \(C\_m = \(\(C\)\(+\)\(C\_p\)\(\ \ \ \)\)\)], "Input"],

Cell[BoxData[
    \(C\_m\ d = \(\[Epsilon]\_0\) 
          S + \(\(C\_p\)\(\ \)\(d\)\(\ \ \ \)\)\)], "Input"],

Cell[BoxData[
    \(\[Epsilon]\_0 = y\_0\/S\)], "Input"],

Cell[BoxData[
    \(C = \(\[Epsilon]\_0\) S\_0\/d + \(\[Epsilon]\_0\) \(\[Epsilon]\_r\) 
          S\_1\/d\)], "Input"],

Cell[BoxData[
    \(C\_m = \(\[Epsilon]\_0\) \(\[Epsilon]\_r\) S\/d + 
        C\_p\  - \(\(\[Epsilon]\_0\/d\)\(\ \)\((\[Epsilon]\_r - 
              1)\)\(\ \)\(S\_0\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\[Epsilon]\_r = 1 + \(a\ d\)\/\[Epsilon]\_0\)], "Input"],

Cell[BoxData[
    \(S\_0 = 
      r\^2\ arccos \((x\/r - 1)\) + \((r - 
              x)\)\ \@\(2\ r\ x - x\^2\)\)], "Input"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 547}},
WindowSize->{495, 389},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 59, 1, 48, "Input"],
Cell[1779, 52, 72, 1, 35, "Input"],
Cell[1854, 55, 109, 2, 35, "Input"],
Cell[1966, 59, 56, 1, 46, "Input"],
Cell[2025, 62, 119, 2, 48, "Input"],
Cell[2147, 66, 189, 3, 48, "Input"],
Cell[2339, 71, 76, 1, 52, "Input"],
Cell[2418, 74, 125, 3, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

