PROGRAM RK4ODP
USE PORTLIB
!Este es un programa para probar el metodo
!de Runge-Kutta de orden 4 en el caso del
!Oscilador de Doble Pozo
IMPLICIT NONE
REAL::b,h,f,f0,f1,p,t,x,v,tiempo,t0,t1
INTEGER::i,j,g,n,m
REAL,ALLOCATABLE,DIMENSION(:,:,:)::posres,velres,fases
REAL,ALLOCATABLE,DIMENSION(:)::fuerza
REAL,DIMENSION(4)::k,l
PRINT *, "Introduce los extremos del intervalo"
PRINT *, "t0 y t1:"
READ *,t0
READ *,t1
PRINT *, "Introduce las condiciones iniciales x(0) y v(0):"
READ *,x
READ *,v
PRINT *, "Introduce las divisiones del intervalo temporal, n"
READ *,n
PRINT *, "Introduce el coeficiente de amortiguamiento, b"
READ *,b
PRINT *, "Introduce el intervalo de la fuerza, F:"
PRINT *, "amplitud inicial y final, f0 y f1:"
READ *,f0
READ *,f1
PRINT *, "Introduce las divisiones del intervalo virial, m"
READ *,m

ALLOCATE(posres(n+1,2,m+1),velres(n+1,2,m+1),fases(n+1,2,m+1),fuerza(m+1))
h=(t1-t0)/n
t=t0
p=(f1-f0)/m
DO g=1,m+1
posres(1,1,g)=t
posres(1,2,g)=x
velres(1,1,g)=t
velres(1,2,g)=v
fases(1,1,g)=x
fases(1,2,g)=v
END DO

tiempo=TIMEF()
DO g=1,m+1
f=f0+p*(g-1)
DO i=1,n
k(1)=v
l(1)=-b*v-x*x*x+x+f*cos(t)
DO j=1,2
k(j+1)=v+l(j)*h/2
l(j+1)=-b*(v+l(j)*h/2)-(x+k(j)*h/2)*(x+k(j)*h/2)*(x+k(j)*h/2)+(x+k(j)*h/2)+f*cos(t+h/2)
END DO
k(4)=v+l(3)*h
l(4)=-b*(v+l(3)*h)-(x+k(3)*h)*(x+k(3)*h)*(x+k(3)*h)+(x+k(3)*h)+f*cos(t+h)
x=x+(h/6)*(k(1)+2*k(2)+2*k(3)+k(4))
v=v+(h/6)*(l(1)+2*l(2)+2*l(3)+l(4))
t=t0+h*i
posres(i+1,1,g)=t
posres(i+1,2,g)=x
velres(i+1,1,g)=t
velres(i+1,2,g)=v
fases(i+1,1,g)=x
fases(i+1,2,g)=v
END DO
fuerza(g)=f
END DO
tiempo=TIMEF()

PRINT *,t," t"
PRINT *,x," x"
PRINT *,f," fuerza"
PRINT *,tiempo," segundos"


OPEN(8,file="posicion.txt")
DO g=1,m+1
DO j=1,2
	DO i=1,n+1
	WRITE (8,*) posres(i,j,g)
	END DO
	WRITE (8,*) 'a'
END DO
WRITE (8,*) 'pppp'
END DO
CLOSE(8)
OPEN(9,file="velocidad.txt")
DO g=1,m+1
DO j=1,2
	DO i=1,n+1
	WRITE (9,*) velres(i,j,g)
	END DO
	WRITE (9,*) 'a'
WRITE (9,*) 'vvvv'
END DO
END DO
CLOSE(9)
OPEN(10,file="fases.txt")
DO g=1,m+1
DO j=1,2
	DO i=1,n+1
	WRITE (10,*) fases(i,j,g)
	END DO
	WRITE (10,*) 'a'
WRITE (10,*) 'ffff'
END DO
END DO
CLOSE(10)
OPEN(11,file="fuerza.txt")
DO g=1,m+1
	WRITE (11,*) fuerza(g)
END DO
CLOSE(11)
END PROGRAM RK4ODP