PROGRAM RK4Oscilador
USE PORTLIB
!Este es un programa para probar el metodo
!de Runge-Kutta de orden 4 en el caso del
!Oscilador de Doble Pozo
IMPLICIT NONE
REAL::b,h,f,t,x,v,tiempo,t0,t1
INTEGER::i,j,n
REAL,ALLOCATABLE,DIMENSION(:,:)::posres,velres
REAL,DIMENSION(4)::k,l
PRINT *, "Introduce los extremos del intervalo"
PRINT *, "t0 y t1:"
READ *,t0
READ *,t1
PRINT *, "Introduce las condiciones iniciales x(0) y v(0):"
READ *,x
READ *,v
PRINT *, "Introduce las divisiones del intervalo, N"
READ *,n
PRINT *, "Introduce el coeficiente de amortiguamiento, b"
READ *,b
PRINT *, "Introduce la amplitud de la fuerza, F"
READ *,f

ALLOCATE(posres(n+1,2),velres(n+1,2))
h=(t1-t0)/n
t=t0
posres(1,1)=t
posres(1,2)=x
velres(1,1)=t
velres(1,2)=v

tiempo=TIMEF()
DO i=1,n
k(1)=v
l(1)=-b*v-x*x*x+x+f*cos(t)
DO j=1,2
k(j+1)=v+l(j)*h/2
l(j+1)=-b*(v+l(j)*h/2)-(x+k(j)*h/2)*(x+k(j)*h/2)*(x+k(j)*h/2)+(x+k(j)*h/2)+f*cos(t+h/2)
END DO
k(4)=v+l(3)*h
l(4)=-b*(v+l(3)*h)-(x+k(3)*h)*(x+k(3)*h)*(x+k(3)*h)+(x+k(3)*h)+f*cos(t+h)
x=x+(h/6)*(k(1)+2*k(2)+2*k(3)+k(4))
v=v+(h/6)*(l(1)+2*l(2)+2*l(3)+l(4))
t=t0+h*i
posres(i+1,1)=t
posres(i+1,2)=x
velres(i+1,1)=t
velres(i+1,2)=v
END DO
tiempo=TIMEF()

PRINT *,t," t"
PRINT *,x," x"
PRINT *,tiempo," segundos"
PRINT *,h," h"

OPEN(8,file="posicion.txt")
DO j=1,2
	DO i=1,n+1
	WRITE (8,*) posres(i,j)
	END DO
	WRITE (8,*) 'a'
END DO
CLOSE(8)
OPEN(9,file="velocidad.txt")
DO j=1,2
	DO i=1,n+1
	WRITE (9,*) velres(i,j)
	END DO
	WRITE (9,*) 'a'
END DO
CLOSE(9)

END PROGRAM RK4Oscilador 